<?php
// bot.php - فایل اصلی ربات

// تنظیمات اولیه
define('BOT_TOKEN', '6657939603:AAFD8Yqc0RlrfgtcGzu0BL8EbjB2AY01dS8');
define('SOURCE_CHANNEL', '@RapRelease'); // کانال مبدا
define('TARGET_CHANNEL', '@MUZAeeeK'); // کانال مقصد شما
define('CAPTION', '@MUZAeeeK 🎵'); // کپشن ثابت

// دریافت آپدیت از تلگرام
$update = json_decode(file_get_contents('php://input'), true);

// لاگ برای دیباگ (اختیاری)
file_put_contents('log.txt', print_r($update, true), FILE_APPEND);

// بررسی اینکه آیا پیام جدیدی از کانال مبدا آمده
if (isset($update['channel_post'])) {
    $message = $update['channel_post'];
    $chat_username = $message['chat']['username'] ?? '';
    
    // بررسی اینکه پیام از کانال مبدا است
    if ('@' . $chat_username == SOURCE_CHANNEL) {
        // بررسی اینکه پیام شامل فایل صوتی است
        if (isset($message['audio'])) {
            processAudio($message['audio'], $message['message_id']);
        }
    }
}

function processAudio($audio, $message_id) {
    $file_id = $audio['file_id'];
    $original_title = $audio['title'] ?? '';
    $original_performer = $audio['performer'] ?? '';
    
    // دانلود فایل
    $file_path = downloadFile($file_id);
    
    if ($file_path) {
        // ویرایش متادیتا
        $new_file_path = editAudioMetadata($file_path, $original_title);
        
        // آپلود به کانال مقصد
        if ($new_file_path && file_exists($new_file_path)) {
            uploadToChannel($new_file_path, $original_performer);
            
            // حذف فایل‌های موقت
            @unlink($file_path);
            @unlink($new_file_path);
        }
    }
}

function downloadFile($file_id) {
    // دریافت مسیر فایل
    $file_info = apiRequest('getFile', ['file_id' => $file_id]);
    
    if (!isset($file_info['result']['file_path'])) {
        return false;
    }
    
    $file_path = $file_info['result']['file_path'];
    $file_url = "https://api.telegram.org/file/bot" . BOT_TOKEN . "/" . $file_path;
    
    // دانلود فایل
    $file_content = file_get_contents($file_url);
    
    if ($file_content === false) {
        return false;
    }
    
    // ذخیره موقت
    $temp_file = 'temp_' . time() . '_' . rand(1000, 9999) . '.mp3';
    file_put_contents($temp_file, $file_content);
    
    return $temp_file;
}

function editAudioMetadata($file_path, $original_title) {
    // نصب getID3 لازم است - فایل getid3.php را دانلود و در کنار این فایل قرار دهید
    // دانلود از: https://github.com/JamesHeinrich/getID3
    
    if (!file_exists('getid3/getid3.php')) {
        // اگر getID3 وجود ندارد، فقط نام فایل را تغییر می‌دهیم
        return simpleEdit($file_path, $original_title);
    }
    
    require_once('getid3/getid3.php');
    require_once('getid3/write.php');
    
    $getID3 = new getID3;
    $getID3->setOption(['encoding' => 'UTF-8']);
    
    // خواندن تگ‌های فعلی
    $file_info = $getID3->analyze($file_path);
    
    // تنظیم تگ‌های جدید
    $TaggingFormat = 'UTF-8';
    $tagwriter = new getid3_writetags;
    $tagwriter->filename = $file_path;
    $tagwriter->tagformats = ['id3v2.3'];
    $tagwriter->overwrite_tags = true;
    $tagwriter->tag_encoding = $TaggingFormat;
    $tagwriter->remove_other_tags = true;
    
    // آماده‌سازی داده‌های جدید
    $TagData = [
        'title' => [cleanText($original_title)],
        'album' => [''],
        'comment' => [''],
        'composer' => [''],
        'unsynchronised_lyric' => ['T.me/YAKOOzA']
    ];
    
    $tagwriter->tag_data = $TagData;
    
    // نوشتن تگ‌ها
    if ($tagwriter->WriteTags()) {
        $new_file = 'edited_' . time() . '_' . rand(1000, 9999) . '.mp3';
        copy($file_path, $new_file);
        return $new_file;
    }
    
    return simpleEdit($file_path, $original_title);
}

function simpleEdit($file_path, $original_title) {
    // اگر getID3 در دسترس نیست، حداقل کپی ساده
    $new_file = 'edited_' . time() . '_' . rand(1000, 9999) . '.mp3';
    copy($file_path, $new_file);
    return $new_file;
}

function cleanText($text) {
    // حذف @RapRelease - از متن
    $text = str_replace('@RapRelease - ', '', $text);
    $text = str_replace('@RapRelease-', '', $text);
    $text = str_replace('@RapRelease ', '', $text);
    $text = str_replace('@RapRelease', '', $text);
    $text = trim($text);
    return $text;
}

function uploadToChannel($file_path, $performer) {
    $performer = cleanText($performer);
    
    $post_fields = [
        'chat_id' => TARGET_CHANNEL,
        'audio' => new CURLFile(realpath($file_path)),
        'caption' => CAPTION,
        'performer' => $performer,
        'title' => $performer
    ];
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "https://api.telegram.org/bot" . BOT_TOKEN . "/sendAudio");
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $post_fields);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    
    $result = curl_exec($ch);
    curl_close($ch);
    
    return json_decode($result, true);
}

function apiRequest($method, $parameters) {
    $url = "https://api.telegram.org/bot" . BOT_TOKEN . "/" . $method;
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($parameters));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    
    $result = curl_exec($ch);
    curl_close($ch);
    
    return json_decode($result, true);
}
?>
