<?php
// setup-db.php

// جلوگیری از دسترسی مستقیم بدون مجوز
// if (!isset($_SERVER['HTTP_REFERER']) || strpos($_SERVER['HTTP_REFERER'], 'your-domain.com') === false) {
//     die("دسترسی غیرمجاز!");
// }

// تنظیمات دیتابیس
// $db_host = 'localhost';
// $db_user = 'boogeyir_self'; // کاربر دیتابیس
// $db_pass = '5KFZMbHMTUyeJbX'; // رمز عبور دیتابیس
// $db_name = 'boogeyir_self'; // نام دیتابیس


// setup.php

require 'config.php';

// اتصال به دیتابیس
$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);

// بررسی اتصال
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// ایجاد جدول برای ذخیره لاگ‌ها
$sql = "CREATE TABLE IF NOT EXISTS logs (
    id INT(6) UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    user_id INT(11) NOT NULL,
    action VARCHAR(255) NOT NULL,
    details TEXT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
)";

if ($conn->query($sql) === TRUE) {
    echo "Table 'logs' created successfully\n";
} else {
    echo "Error creating table: " . $conn->error;
}

// ایجاد جدول برای ذخیره وضعیت کاربران
$sql = "CREATE TABLE IF NOT EXISTS user_states (
    user_id INT(11) PRIMARY KEY,
    state VARCHAR(50) NOT NULL,
    data TEXT,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
)";

if ($conn->query($sql) === TRUE) {
    echo "Table 'user_states' created successfully\n";
} else {
    echo "Error creating table: " . $conn->error;
}

// ایجاد جدول برای ذخیره درخواست‌های کاربران
$sql = "CREATE TABLE IF NOT EXISTS submissions (
    id INT(6) UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    user_id INT(11) NOT NULL,
    submission_date DATE NOT NULL,
    count INT(11) NOT NULL DEFAULT 0,
    UNIQUE KEY unique_user_date (user_id, submission_date)
)";

if ($conn->query($sql) === TRUE) {
    echo "Table 'submissions' created successfully\n";
} else {
    echo "Error creating table: " . $conn->error;
}

$conn->close();
?>


/*

// ایجاد اتصال
try {
    $conn = new mysqli($db_host, $db_user, $db_pass);
    
    // بررسی خطا
    if ($conn->connect_error) {
        throw new Exception("Connection failed: " . $conn->connect_error);
    }

    // 1. ایجاد دیتابیس
    $conn->query("CREATE DATABASE IF NOT EXISTS $db_name 
        CHARACTER SET utf8mb4 
        COLLATE utf8mb4_persian_ci");

    echo "✅ دیتابیس ایجاد شد!<br>";

    // انتخاب دیتابیس
    $conn->select_db($db_name);

    // 2. ایجاد جدول users
    $sql = "CREATE TABLE IF NOT EXISTS users (
        user_id BIGINT(20) PRIMARY KEY,
        first_name VARCHAR(255) NOT NULL,
        last_name VARCHAR(255) NOT NULL,
        student_number VARCHAR(20) UNIQUE,
        phone_number VARCHAR(15) UNIQUE,
        registration_status ENUM('pending', 'completed') DEFAULT 'pending',
        registered_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_persian_ci";

    $conn->query($sql);
    echo "✅ جدول users ایجاد شد!<br>";

    // 3. ایجاد جدول logs (اختیاری)
    $conn->query("CREATE TABLE IF NOT EXISTS logs (
        id INT AUTO_INCREMENT PRIMARY KEY,
        user_id BIGINT(20),
        action VARCHAR(50),
        details TEXT,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    )");
    echo "✅ جدول logs ایجاد شد!<br>";

    // بستن اتصال
    $conn->close();

    echo "<h3>راه اندازی دیتابیس با موفقیت انجام شد!</h3>";

} catch(Exception $e) {
    echo "⛔ خطا: " . $e->getMessage();
    
    // حذف دیتابیس در صورت خطا
    if(isset($conn)) {
        $conn->query("DROP DATABASE IF EXISTS $db_name");
    }
}

// حذف فایل پس از اجرا (اختیاری)
// unlink(__FILE__);
?>



*/